from __future__ import print_function, unicode_literals
import sys, io, logging, traceback
import scx
import translator
import translate_sc3
import translate_mail
import translate_channel
import translate_tips
import translate_strings

logFile = io.open('translate.log', 'w', encoding='UTF-8')
logging.basicConfig(stream=logFile, level=logging.WARNING)

scripts = [
	"SG00_01.SCX",
	"SG01_01.SCX",
	"SG01_02.SCX",
	"SG01_03.SCX",
	"SG01_04.SCX",
	"SG01_05.SCX",
	"SG01_06.SCX",
	"SG01_07.SCX",
	"SG01_08.SCX",
	"SG01_09.SCX",
	"SG01_10.SCX",
	"SG01_11.SCX",
	"SG01_12.SCX",
	"SG01_13.SCX",
	"SG02_01.SCX",
	"SG02_02.SCX",
	"SG02_03.SCX",
	"SG02_05.SCX",
	"SG02_06.SCX",
	"SG02_07.SCX",
	"SG02_08.SCX",
	"SG02_09.SCX",
	"SG02_10.SCX",
	"SG02_11.SCX",
	"SG02_12.SCX",
	"SG02_13.SCX",
	"SG02_14.SCX",
	"SG02_15.SCX",
	"SG02_16.SCX",
	"SG02_17.SCX",
	"SG02_18.SCX",
	"SG02_19.SCX",
	"SG03_01.SCX",
	"SG03_02.SCX",
	"SG03_03.SCX",
	"SG03_04.SCX",
	"SG03_05.SCX",
	"SG03_06.SCX",
	"SG03_07.SCX",
	"SG03_08.SCX",
	"SG03_09.SCX",
	"SG03_10.SCX",
	"SG03_11.SCX",
	"SG03_12.SCX",
	"SG03_13.SCX",
	"SG03_14.SCX",
	"SG04_01.SCX",
	"SG04_02.SCX",
	"SG04_03.SCX",
	"SG04_04.SCX",
	"SG04_05.SCX",
	"SG04_06.SCX",
	"SG04_07.SCX",
	"SG04_08.SCX",
	"SG04_09.SCX",
	"SG04_10.SCX",
	"SG04_11.SCX",
	"SG04_12.SCX",
	"SG04_13.SCX",
	"SG04_14.SCX",
	"SG04_15.SCX",
	"SG04_16.SCX",
	"SG04_17.SCX",
	"SG04_18.SCX",
	"SG04_19.SCX",
	"SG04_20.SCX",
	"SG04_21.SCX",
	"SG04_22.SCX",
	"SG04_23.SCX",
	"SG04_24.SCX",
	"SG04_25.SCX",
	"SG05_01.SCX",
	"SG05_02.SCX",
	"SG05_03.SCX",
	"SG05_04.SCX",
	"SG05_05.SCX",
	"SG05_06.SCX",
	"SG05_07.SCX",
	"SG05_08.SCX",
	"SG05_09.SCX",
	"SG05_10.SCX",
	"SG05_11.SCX",
	"SG05_12.SCX",
	"SG05_13.SCX",
	"SG05_14.SCX",
	"SG05_15.SCX",
	"SG05_16.SCX",
	"SG05_17.SCX",
	"SG06_01.SCX",
	"SG06_02.SCX",
	"SG06_03.SCX",
	"SG06_04.SCX",
	"SG06_05.SCX",
	"SG06_06.SCX",
	"SG06_07.SCX",
	"SG06_08.SCX",
	"SG06_09.SCX",
	"SG06_10.SCX",
	"SG06_11.SCX",
	"SG06_12.SCX",
	"SG06_13.SCX",
	"SG06_14.SCX",
	"SG06_15.SCX",
	"SG06_16.SCX",
	"SG06_17.SCX",
	"SG06_18.SCX",
	"SG06_19.SCX",
	"SG06_20.SCX",
	"SG06_21.SCX",
	"SG06_22.SCX",
	"SG06_23.SCX",
	"SG06_24S.SCX",
	"SG06_25S.SCX",
	"SG07_01.SCX",
	"SG07_02.SCX",
	"SG07_03.SCX",
	"SG07_04.SCX",
	"SG07_05.SCX",
	"SG07_06.SCX",
	"SG07_07.SCX",
	"SG07_08.SCX",
	"SG07_09.SCX",
	"SG07_10.SCX",
	"SG07_11.SCX",
	"SG07_12.SCX",
	"SG07_13.SCX",
	"SG07_14F.SCX",
	"SG07_15F.SCX",
	"SG07_16F.SCX",
	"SG08_01.SCX",
	"SG08_02.SCX",
	"SG08_03.SCX",
	"SG08_04.SCX",
	"SG08_05.SCX",
	"SG08_06.SCX",
	"SG08_07.SCX",
	"SG08_08.SCX",
	"SG08_09.SCX",
	"SG08_10.SCX",
	"SG08_11.SCX",
	"SG08_12.SCX",
	"SG08_13R.SCX",
	"SG08_14R.SCX",
	"SG09_01.SCX",
	"SG09_02.SCX",
	"SG09_03.SCX",
	"SG09_04.SCX",
	"SG09_05.SCX",
	"SG09_06.SCX",
	"SG09_07.SCX",
	"SG09_08.SCX",
	"SG09_09.SCX",
	"SG09_10.SCX",
	"SG09_11.SCX",
	"SG09_12.SCX",
	"SG10_01.SCX",
	"SG10_02.SCX",
	"SG10_03.SCX",
	"SG10_04.SCX",
	"SG10_05M.SCX",
	"SG10_06M.SCX",
	"SG10_07M.SCX",
	"SG10_08M.SCX",
	"SG10_09M.SCX",
	"SG10_10C.SCX",
	"SG10_11C.SCX",
	"SG10_12C.SCX",
	"SG11_01.SCX",
	"SG11_02.SCX",
	"SG11_03.SCX",
	"SG11_04.SCX",
	"SG11_05.SCX",
	"SG11_06.SCX",
	"SG11_07.SCX",
	"SG11_08.SCX",
]
def progress():
	sys.stdout.write(".")
	sys.stdout.flush()
context = ''
try:
	scx.load_characters_data('input_map.bin', translator.enable_cyrillic)
	scx.setup_for_main_text(translator.enable_value_transform)
	scx.characters_map['\u3000'] = scx.characters_map[' ']
	#scx.map_fullwidth_to_normal()
	for s in scripts:
		context = s
		translate_sc3.translate_sc3('script/' + s, 'translation/' + s[:s.rfind('.')] + '.txt', 'translated_script/' + s)
		progress()
	context = '_MAIL.SCX'
	translate_mail.translate_mail('script/_MAIL.SCX', 'translation/mail.txt', 'translated_script/_MAIL.SCX')
	progress()
	context = '_TIPS.SCX'
	translate_tips.translate_tips('script/_TIPS.SCX', 'translation/tips.txt', 'translated_script/_TIPS.SCX')
	progress()
	context = '_ATCH.SCX'
	translate_channel.translate_channel('script/_ATCH.SCX', 'translation/channel.txt', 'translated_script/_ATCH.SCX')
	progress()
	context = '_STARTUP_WIN.SCX'
	translate_strings.translate_strings('script/_STARTUP_WIN.SCX', 'translation/startup_win.txt', 'translated_script/_STARTUP_WIN.SCX')
	progress()
	context = '_SYSTEM.SCX'
	translate_strings.translate_strings('script/_SYSTEM.SCX', 'translation/system.txt', 'translated_script/_SYSTEM.SCX')
	progress()
	context = 'CLRFLG.SCX'
	translate_strings.translate_strings('script/CLRFLG.SCX', 'translation/clrflg.txt', 'translated_script/CLRFLG.SCX')
	progress()
	context = 'MACROSYS.SCX'
	translate_strings.translate_strings('script/MACROSYS.SCX', 'translation/macrosys.txt', 'translated_script/MACROSYS.SCX')
	progress()
	context = 'MACROSYS2.SCX'
	translate_strings.translate_strings('script/MACROSYS2.SCX', 'translation/macrosys2.txt', 'translated_script/MACROSYS2.SCX')
	progress()
except Exception as e:
	print()
	print("An error has occured during processing of " + context + '.')
	traceback.print_exc()
	logFile.close()
	sys.exit(1)
print()
print("Finished with %d warning(s)" % translator.num_warnings)
logFile.close()
