﻿# -*- coding: UTF-8 -*-
from __future__ import print_function, unicode_literals
import io, sys, os, struct, logging
import scx, translator


def translate_channel(input_file, translations_file, output_file):
	logger = logging.getLogger(os.path.basename(input_file))
	scx.load_characters_data('input_map.bin', translator.enable_cyrillic)

	data = scx.ScxData(input_file)
	translations = translator.load_translations(translations_file, fix_quotes=True, fix_two_spaces=False, fix_em_dash=True)
	output = scx.OutputBuilder(None)
	if len(data.labels) < 2:
		raise Exception("invalid labels count")
	input_pos = data.labels[1]
	output_pos = data.labels[1]
	output.add_code(data.content[data.eip:input_pos])
	output.add_label(data.labels[0])
	text_pos = 0
	for block in range(1, len(data.labels)):
		output.add_label(output_pos)
		next_pos = data.content.find(b'\xFF\xFF', input_pos)
		if next_pos == -1 or (next_pos - input_pos) % 2 or (block+1 < len(data.labels) and data.labels[block+1] != next_pos + 2):
			raise Exception("invalid string ids list")
		string_ids = struct.unpack_from('<' + str((next_pos - input_pos) // 2) + 'H', data.content, input_pos)
		output_ids = []
		text = ''
		text_count = 0
		for id_ in string_ids:
			parsed = data.parse_text(id_)
			if parsed == [] or parsed == ["\u3000"]:
				output_ids.append(output.serialize_text(parsed))
				continue
			if text_count:
				text += '|'
			text += scx.text_to_string(parsed)
			text_count += 1
			if text_pos == len(translations):
				logger.warning("too few keys in translation, should be: " + text)
				translator.num_warnings += 1
				output_ids.append(output.serialize_text(scx.string_to_text(text)))
				text = ''
				text_count = 0
			elif text_count == translations[text_pos][0].count('|') + 1:
				if translator.normalize_translation_key(text) != translator.normalize_translation_key(translations[text_pos][0]):
					logger.warning("mismatch in translation keys:")
					logger.warning("seen:      " + translations[text_pos][0])
					logger.warning("should be: " + text)
					translator.num_warnings += 1
				for translated in translations[text_pos][1].split('|'):
					output_ids.append(output.serialize_text(scx.string_to_text(translated)))
				text_pos += 1
				text = ''
				text_count = 0
		if text:
			logger.error("translation key overlaps group boundary:")
			logger.error("seen:      " + translations[text_pos][0])
			logger.error("should be: " + text)
			raise Exception("translation key overlaps group boundary")
		output_ids.append(0xFFFF)
		output.add_code(struct.pack('<' + str(len(output_ids)) + 'H', *output_ids))
		output_pos += 2 * len(output_ids)
		input_pos = next_pos + 2
	with io.open(output_file, 'wb') as f:
		output.save(f)


if __name__ == "__main__":
	logging.basicConfig()
	translate_channel('script/' + sys.argv[1], sys.argv[2], 'translated_script/' + sys.argv[1])
