# -*- coding: UTF-8 -*-
from __future__ import print_function, unicode_literals
import io
import scx


enable_key_transform = True
enable_value_transform = True
enable_cyrillic = True


num_warnings = 0


fancy2normal_table = {ord(x):y for x, y in zip(scx.wide + "　／＿＾" + "‘’“”", scx.ansi + " /_^" + "''\"\"")}
fancy2normal_table[ord('，')] = ', '
fancy2normal_table[ord('̠')] = ''
def normalize_translation_key(key):
	if not enable_key_transform:
		return key
	if key.endswith('，'):
		key = key[:-1] + ','
	return (key
		.replace('Radio Kaikan', 'Radi-Kan')
		.replace(': ', ':')
		.replace('，" ', '," ')
		.replace('，|', ',|')
		.replace('，[br]', ',[br]')
		.replace('，[/link]', ',[/link]')
		.replace('，000', ',000')
		.translate(fancy2normal_table))



def load_translations(filename, fix_quotes=True, use_speech_quotes=False, fix_two_spaces=False, fix_em_dash=False):
	translations = []
	with io.open(filename, 'r', encoding='utf-8') as f:
		for lineno, x in enumerate(f.readlines()):
			key, value = x.rstrip('\r\n').replace('⑯','²').split('\t')
			if enable_value_transform:
				value = value.replace('\'', '’')
			if fix_two_spaces:
				if enable_key_transform:
					key = key.replace('  ',' ')
				if enable_value_transform:
					value = value.replace('  ',' ')
			if enable_value_transform and enable_cyrillic:
				value = value.replace('ó', 'о́')
			if enable_value_transform and fix_quotes:
				if use_speech_quotes:
					lines = value.split('|')
					for i in range(len(lines)):
						line = lines[i]
						pos, pos2 = scx.find_speech_markers(line)
						if pos != -1:
							lines[i] = line[:pos] + '“' + line[pos+1:pos2] + '”' + line[pos2+1:]
						if line.count('"') == 1:
							pos = line.find('"')
							if value[0] == '[' and pos == scx.find_unescaped_bracket(line, ']', 0) + 1:
								lines[i] = line[:pos] + '“' + line[pos+1:]
							elif pos == len(value) - 1:
								lines[i] = line[:pos] + '”'
					value = '|'.join(lines)
				pos = 0
				while True:
					pos = value.find('"', pos)
					if pos == -1:
						break
					pos2 = value.find('"', pos + 1)
					if pos2 == -1:
						raise Exception("mismatched quotes in {}:{}".format(filename, lineno+1))
					value = value[:pos] + '«' + value[pos+1:pos2] + '»' + value[pos2+1:]
			if enable_value_transform and fix_em_dash:
				value = value.replace(' - ', ' — ').replace('–', '—')
			translations.append([key, value])
	return translations
