from __future__ import print_function, unicode_literals
import io, sys, struct, os
with io.open(sys.argv[1], 'r', encoding='ascii') as listf:
	files = []
	for s in listf:
		s = s.rstrip('\r\n')
		files.append((s, os.stat(s).st_size))
numFiles = len(files)
offset = 0x44 + 0x100 * numFiles
offset = (offset + 0x7FF) & -0x800
for _ in range(numFiles):
	files[_] = (files[_][0], files[_][1], offset)
	offset += files[_][1]
	offset = (offset + 0x7FF) & -0x800
with io.open(sys.argv[2], 'wb') as g:
	g.write(b'MPK\0\0\0\2\0' + struct.pack('<I', numFiles) + b'\0' * 0x38)
	for i, data in enumerate(files):
		g.write(struct.pack('<IQQQ228s', i, data[2], data[1], data[1], os.path.basename(data[0]).encode('ascii').ljust(228, b'\0')))
	gpos = 0x44 + 0x100 * numFiles
	for name, size, offset in files:
		g.write(b'\0' * (offset - gpos))
		with io.open(name, 'rb') as f2:
			data = f2.read(size)
		if len(data) != size:
			print("Read error")
			sys.exit(1)
		g.write(data)
		gpos = offset + len(data)
